<?php

namespace App\Models {

    /**
     * App\Models\Resolucion
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property \Illuminate\Support\Carbon|null $fecha_envio
     * @property boolean $enviada_resolucion
     * @property int|null $id_usuario_firma
     * @property \Illuminate\Support\Carbon|null $fecha_firma
     * @property string|null $archivo_firmado
     * @property string|null $archivo_resolucion
     * @property string|null $asunto_resolucion
     * @property string|null $visto_resolucion
     * @property \Illuminate\Support\Carbon $fecha_resolucion
     * @property string $num_resolucion
     * @property int $id_tipo_resolucion
     * @property int $id_estado
     * @property int $id_resolucion
     * @property-read mixed $url_archivo
     * @property-read mixed $url_archivo_firmado
     * @property-read mixed $tiene_archivo
     * @property-read mixed $esta_firmada
     * @property-read mixed $es_borrador
     * @property-read mixed $puede_editarse
     * @property-read mixed $puede_firmarse
     * @property-read mixed $tiene_firmas_pendientes
     * @property-read mixed $personas
     * @property-read \App\Models\Estado $estado
     * @property-read \App\Models\TipoResolucion $tipoResolucion
     * @property-read \App\Models\User $usuarioCreador
     * @property-read \App\Models\User $usuarioFirmante
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Persona> $personas
     * @property-read int|null $personas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Persona> $personasInvolucradas
     * @property-read int|null $personasInvolucradas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\ColaFirma> $colaFirmas
     * @property-read int|null $colaFirmas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\HistorialFirma> $historialFirmas
     * @property-read int|null $historialFirmas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Notificacion> $notificaciones
     * @property-read int|null $notificaciones_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Queja> $quejas
     * @property-read int|null $quejas_count
     * @property-read \App\Models\DocumentoTextoOcr $documentoTexto
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\ConsultaAsistente> $consultasAsistente
     * @property-read int|null $consultasAsistente_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PersonaResolucionDatos> $personasRelacionadasDatos
     * @property-read int|null $personasRelacionadasDatos_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PersonaResolucionDatos> $personasRelacionadas
     * @property-read int|null $personasRelacionadas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RegistroFirmaEntrega> $registrosFirmaEntrega
     * @property-read int|null $registrosFirmaEntrega_count
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereIdEstado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereIdTipoResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereNumResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereFechaResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereVistoResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereAsuntoResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereArchivoResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereArchivoFirmado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereFechaFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereIdUsuarioFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereEnviadaResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereFechaEnvio($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion query()
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion activos() {@see App\Models\Resolucion::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion porEstado(mixed $idEstado) {@see App\Models\Resolucion::scopePorEstado()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion borrador() {@see App\Models\Resolucion::scopeBorrador()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion firmadas() {@see App\Models\Resolucion::scopeFirmadas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion publicadas() {@see App\Models\Resolucion::scopePublicadas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion pendientesFirma() {@see App\Models\Resolucion::scopePendientesFirma()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion porTipo(mixed $idTipo) {@see App\Models\Resolucion::scopePorTipo()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion porAnio(mixed $anio) {@see App\Models\Resolucion::scopePorAnio()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion buscar(mixed $busqueda) {@see App\Models\Resolucion::scopeBuscar()}
     * @method static \Illuminate\Database\Eloquent\Builder<Resolucion>|Resolucion conRelaciones() {@see App\Models\Resolucion::scopeConRelaciones()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Resolucion extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Area
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string|null $descripcion
     * @property string $nombre_area
     * @property int $id_area
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereIdArea($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereNombreArea($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area query()
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area activos() {@see App\Models\Area::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<Area>|Area buscar(mixed $search) {@see App\Models\Area::scopeBuscar()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Area extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Auditoria
     *
     * @property \Illuminate\Support\Carbon $fecha_accion
     * @property string|null $user_agent
     * @property string|null $ip_address
     * @property array|null $datos_nuevos
     * @property array|null $datos_anteriores
     * @property string|null $descripcion
     * @property int|null $id_registro
     * @property string|null $tabla_afectada
     * @property string $accion
     * @property int|null $id_usuario
     * @property int $id_auditoria
     * @property-read mixed $accion_formateada
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereIdAuditoria($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereAccion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereTablaAfectada($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereIdRegistro($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereDatosAnteriores($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereDatosNuevos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereIpAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereUserAgent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria whereFechaAccion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Auditoria>|Auditoria query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Auditoria extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Cargo
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string|null $descripcion
     * @property string $nombre_cargo
     * @property string $codigo_cargo
     * @property int $id_cargos
     * @property-read \App\Models\User $usuario
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereIdCargos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereCodigoCargo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereNombreCargo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo query()
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo activos() {@see App\Models\Cargo::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<Cargo>|Cargo buscar(mixed $busqueda) {@see App\Models\Cargo::scopeBuscar()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Cargo extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Cliente
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property boolean $i_active
     * @property string|null $tipo_cliente
     * @property int $id_persona
     * @property int $id_cliente
     * @property-read \App\Models\Persona $persona
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Queja> $quejas
     * @property-read int|null $quejas_count
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente whereIdCliente($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente whereIdPersona($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente whereTipoCliente($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente query()
     * @method static \Illuminate\Database\Eloquent\Builder<Cliente>|Cliente activos() {@see App\Models\Cliente::scopeActivos()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Cliente extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\ColaFirma
     *
     * @property string|null $motivo_rechazo
     * @property string|null $observaciones
     * @property \Illuminate\Support\Carbon|null $fecha_firma
     * @property \Illuminate\Support\Carbon|null $fecha_limite
     * @property \Illuminate\Support\Carbon $fecha_solicitud
     * @property mixed $prioridad
     * @property int $id_estado_firma
     * @property int $id_usuario_firmante
     * @property int $id_usuario_solicita
     * @property int $id_resolucion
     * @property int $id_cola_firma
     * @property-read mixed $esta_vencida
     * @property-read mixed $dias_restantes
     * @property-read mixed $color_prioridad
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\User $usuarioSolicita
     * @property-read \App\Models\User $usuarioFirmante
     * @property-read \App\Models\EstadoFirma $estadoFirma
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereIdColaFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereIdUsuarioSolicita($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereIdUsuarioFirmante($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereIdEstadoFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma wherePrioridad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereFechaSolicitud($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereFechaLimite($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereFechaFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereObservaciones($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma whereMotivoRechazo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma query()
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma pendientes() {@see App\Models\ColaFirma::scopePendientes()}
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma firmadas() {@see App\Models\ColaFirma::scopeFirmadas()}
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma rechazadas() {@see App\Models\ColaFirma::scopeRechazadas()}
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma porPrioridad(mixed $prioridad) {@see App\Models\ColaFirma::scopePorPrioridad()}
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma porUsuarioFirmante(mixed $idUsuario) {@see App\Models\ColaFirma::scopePorUsuarioFirmante()}
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma expiradas() {@see App\Models\ColaFirma::scopeExpiradas()}
     * @method static \Illuminate\Database\Eloquent\Builder<ColaFirma>|ColaFirma conRelaciones() {@see App\Models\ColaFirma::scopeConRelaciones()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ColaFirma extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Colaborador
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property int|null $id_tipo_personal
     * @property int|null $id_especialidad
     * @property int|null $id_area
     * @property int|null $id_dependencia
     * @property int|null $id_direcciones
     * @property int|null $id_unidad
     * @property int|null $id_cargos
     * @property int|null $id_rol
     * @property int $id_persona
     * @property string $id_colab_dis
     * @property-read mixed $nombre_completo
     * @property-read mixed $estado_texto
     * @property-read \App\Models\Persona $persona
     * @property-read \App\Models\User $usuario
     * @property-read \App\Models\Cargo $cargo
     * @property-read \App\Models\Unidad $unidad
     * @property-read \App\Models\Direccion $direccion
     * @property-read \App\Models\Dependencia $dependencia
     * @property-read \App\Models\Area $area
     * @property-read \App\Models\Especialidad $especialidad
     * @property-read \App\Models\TipoPersonal $tipoPersonal
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdColabDis($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdPersona($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdRol($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdCargos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdUnidad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdDirecciones($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdDependencia($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdArea($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdEspecialidad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdTipoPersonal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador query()
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador activos() {@see App\Models\Colaborador::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador buscarPorNombre(mixed $search) {@see App\Models\Colaborador::scopeBuscarPorNombre()}
     * @method static \Illuminate\Database\Eloquent\Builder<Colaborador>|Colaborador buscarPorCodigo(mixed $search) {@see App\Models\Colaborador::scopeBuscarPorCodigo()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Colaborador extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\ConfiguracionIa
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property boolean $i_active
     * @property array|null $parametros_adicionales
     * @property float $similarity_threshold
     * @property integer $top_k
     * @property integer $chunk_overlap
     * @property integer $chunk_size
     * @property float $temperatura
     * @property integer $max_tokens
     * @property string|null $url_endpoint
     * @property string $modelo_activo
     * @property int $id_config
     * @property-read mixed $es_modelo_local
     * @property-read mixed $es_modelo_nube
     * @property-read mixed $url_completa
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereIdConfig($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereModeloActivo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereUrlEndpoint($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereMaxTokens($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereTemperatura($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereChunkSize($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereChunkOverlap($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereTopK($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereSimilarityThreshold($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereParametrosAdicionales($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa query()
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa activa() {@see App\Models\ConfiguracionIa::scopeActiva()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConfiguracionIa>|ConfiguracionIa porModelo(mixed $modelo) {@see App\Models\ConfiguracionIa::scopePorModelo()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ConfiguracionIa extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\ConsultaAsistente
     *
     * @property \Illuminate\Support\Carbon $fecha_consulta
     * @property integer|null $valoracion
     * @property array|null $metadata_consulta
     * @property string|null $modelo_ia
     * @property float|null $score_relevancia
     * @property integer|null $tiempo_respuesta_ms
     * @property array|null $chunks_usados
     * @property string|null $contexto_usado
     * @property string $respuesta
     * @property string $pregunta
     * @property mixed $tipo_consulta
     * @property int|null $id_resolucion
     * @property int|null $id_usuario
     * @property int $id_consulta
     * @property-read mixed $tiempo_respuesta_segundos
     * @property-read mixed $tiene_votacion
     * @property-read mixed $num_chunks_usados
     * @property-read mixed $calificacion_texto
     * @property-read mixed $color_votacion
     * @property-read \App\Models\User $usuario
     * @property-read \App\Models\Resolucion $resolucion
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereIdConsulta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereTipoConsulta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente wherePregunta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereRespuesta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereContextoUsado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereChunksUsados($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereTiempoRespuestaMs($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereScoreRelevancia($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereModeloIa($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereMetadataConsulta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereValoracion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente whereFechaConsulta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente query()
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente porUsuario(mixed $idUsuario) {@see App\Models\ConsultaAsistente::scopePorUsuario()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente porResolucion(mixed $idResolucion) {@see App\Models\ConsultaAsistente::scopePorResolucion()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente porTipo(mixed $tipo) {@see App\Models\ConsultaAsistente::scopePorTipo()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente general() {@see App\Models\ConsultaAsistente::scopeGeneral()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente busqueda() {@see App\Models\ConsultaAsistente::scopeBusqueda()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente explicacion() {@see App\Models\ConsultaAsistente::scopeExplicacion()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente resumen() {@see App\Models\ConsultaAsistente::scopeResumen()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente recientes(mixed $dias = 30) {@see App\Models\ConsultaAsistente::scopeRecientes()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente conVotosPositivos() {@see App\Models\ConsultaAsistente::scopeConVotosPositivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente conVotosNegativos() {@see App\Models\ConsultaAsistente::scopeConVotosNegativos()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente rapidas(mixed $milisegundos = 1000) {@see App\Models\ConsultaAsistente::scopeRapidas()}
     * @method static \Illuminate\Database\Eloquent\Builder<ConsultaAsistente>|ConsultaAsistente lentas(mixed $milisegundos = 5000) {@see App\Models\ConsultaAsistente::scopeLentas()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ConsultaAsistente extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Dependencia
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property boolean $i_active
     * @property int|null $id_usuario
     * @property string $nombre_dependencia
     * @property string $cod_dependencia
     * @property int $id_dependencias
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereIdDependencias($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereCodDependencia($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereNombreDependencia($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia query()
     * @method static \Illuminate\Database\Eloquent\Builder<Dependencia>|Dependencia activos() {@see App\Models\Dependencia::scopeActivos()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Dependencia extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Direccion
     *
     * @property string $fecha_actualizacion
     * @property string $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string $nombre_direcciones
     * @property int $id_direcciones
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion whereIdDirecciones($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion whereNombreDirecciones($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion query()
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion activas() {@see App\Models\Direccion::scopeActivas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Direccion>|Direccion buscar(mixed $search) {@see App\Models\Direccion::scopeBuscar()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Direccion extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DocumentoChunk
     *
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property integer|null $num_tokens
     * @property array|null $embedding
     * @property array|null $metadata_chunk
     * @property string $contenido_chunk
     * @property integer $chunk_index
     * @property int $id_documento_texto
     * @property int $id_chunk
     * @property-read mixed $tiene_embedding
     * @property-read mixed $num_palabras
     * @property-read mixed $posicion_inicio
     * @property-read mixed $longitud
     * @property-read \App\Models\DocumentoTextoOcr $documentoTexto
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereIdChunk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereIdDocumentoTexto($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereChunkIndex($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereContenidoChunk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereMetadataChunk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereEmbedding($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereNumTokens($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk query()
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk porDocumento(mixed $idDocumento) {@see App\Models\DocumentoChunk::scopePorDocumento()}
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk ordenados() {@see App\Models\DocumentoChunk::scopeOrdenados()}
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk conEmbedding() {@see App\Models\DocumentoChunk::scopeConEmbedding()}
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoChunk>|DocumentoChunk sinEmbedding() {@see App\Models\DocumentoChunk::scopeSinEmbedding()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DocumentoChunk extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DocumentoTextoOcr
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property \Illuminate\Support\Carbon|null $fecha_procesamiento
     * @property mixed $estado_procesamiento
     * @property array|null $metadatos_ocr
     * @property string|null $texto_procesado
     * @property string $texto_completo
     * @property int $id_resolucion
     * @property int $id_documento_texto
     * @property-read mixed $esta_procesado
     * @property-read mixed $tiene_error
     * @property-read mixed $numero_chunks
     * @property-read mixed $num_paginas
     * @property-read mixed $calidad_ocr
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DocumentoChunk> $chunks
     * @property-read int|null $chunks_count
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereIdDocumentoTexto($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereTextoCompleto($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereTextoProcesado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereMetadatosOcr($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereEstadoProcesamiento($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereFechaProcesamiento($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr query()
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr pendientes() {@see App\Models\DocumentoTextoOcr::scopePendientes()}
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr procesados() {@see App\Models\DocumentoTextoOcr::scopeProcesados()}
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr conError() {@see App\Models\DocumentoTextoOcr::scopeConError()}
     * @method static \Illuminate\Database\Eloquent\Builder<DocumentoTextoOcr>|DocumentoTextoOcr buscarEnTexto(mixed $busqueda) {@see App\Models\DocumentoTextoOcr::scopeBuscarEnTexto()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DocumentoTextoOcr extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\EnvioCredencial
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property \Illuminate\Support\Carbon $fecha_envio
     * @property string|null $ip_address
     * @property string|null $observaciones
     * @property mixed $estado_envio
     * @property int $id_usuario_envia
     * @property string $password_generado_hash
     * @property string $correo_sistema_generado
     * @property string $correo_destino
     * @property int $id_persona_resolucion_datos
     * @property int $id_envio_credencial
     * @property-read mixed $exitoso
     * @property-read mixed $nombre_completo
     * @property-read \App\Models\PersonaResolucionDatos $personaResolucionDatos
     * @property-read \App\Models\User $usuarioEnvia
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereIdEnvioCredencial($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereIdPersonaResolucionDatos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereCorreoDestino($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereCorreoSistemaGenerado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial wherePasswordGeneradoHash($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereIdUsuarioEnvia($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereEstadoEnvio($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereObservaciones($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereIpAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereFechaEnvio($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<EnvioCredencial>|EnvioCredencial query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class EnvioCredencial extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Especialidad
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string $nombre_especialidad
     * @property int $id_especialidad
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad whereIdEspecialidad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad whereNombreEspecialidad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad query()
     * @method static \Illuminate\Database\Eloquent\Builder<Especialidad>|Especialidad activos() {@see App\Models\Especialidad::scopeActivos()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Especialidad extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Estado
     *
     * @property string|null $descripcion
     * @property string $nombre_estado
     * @property int $id_estado
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Resolucion> $resoluciones
     * @property-read int|null $resoluciones_count
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado whereIdEstado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado whereNombreEstado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado query()
     * @method static \Illuminate\Database\Eloquent\Builder<Estado>|Estado porNombre(mixed $nombre) {@see App\Models\Estado::scopePorNombre()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Estado extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\EstadoFirma
     *
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property boolean $i_active
     * @property string $color
     * @property string|null $descripcion
     * @property string $nombre_estado
     * @property int $id_estado_firma
     * @property-read mixed $color_badge
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\ColaFirma> $colaFirmas
     * @property-read int|null $colaFirmas_count
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma whereIdEstadoFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma whereNombreEstado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma whereColor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma query()
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma activos() {@see App\Models\EstadoFirma::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<EstadoFirma>|EstadoFirma porNombre(mixed $nombre) {@see App\Models\EstadoFirma::scopePorNombre()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class EstadoFirma extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\HistorialFirma
     *
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property \Illuminate\Support\Carbon|null $fecha_respuesta_firmaperu
     * @property \Illuminate\Support\Carbon|null $fecha_envio_firmaperu
     * @property string|null $respuesta_firmaperu
     * @property string|null $estado_firmaperu
     * @property string|null $archivo_despues_firma
     * @property string|null $archivo_antes_firma
     * @property string|null $ip_firmante
     * @property string|null $hash_firmado
     * @property string|null $hash_documento
     * @property array|null $certificado_digital
     * @property mixed $metodo_firma
     * @property int $id_usuario
     * @property int $id_resolucion
     * @property int $id_historial_firma
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereIdHistorialFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereMetodoFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereCertificadoDigital($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereHashDocumento($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereHashFirmado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereIpFirmante($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereArchivoAntesFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereArchivoDespuesFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereEstadoFirmaperu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereRespuestaFirmaperu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereFechaEnvioFirmaperu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereFechaRespuestaFirmaperu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma query()
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma porResolucion(mixed $idResolucion) {@see App\Models\HistorialFirma::scopePorResolucion()}
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma porUsuario(mixed $idUsuario) {@see App\Models\HistorialFirma::scopePorUsuario()}
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma firmaPeru() {@see App\Models\HistorialFirma::scopeFirmaPeru()}
     * @method static \Illuminate\Database\Eloquent\Builder<HistorialFirma>|HistorialFirma recientes(mixed $dias = 30) {@see App\Models\HistorialFirma::scopeRecientes()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class HistorialFirma extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Modulo
     *
     * @property string $fecha_actualizacion
     * @property string $fecha_creacion
     * @property boolean $i_active
     * @property mixed $tipo_modulo
     * @property integer $orden
     * @property string|null $icono
     * @property string|null $ruta
     * @property string|null $descripcion
     * @property string $slug
     * @property string $nombre_modulo
     * @property int $id_modulo
     * @property-read mixed $cantidad_permisos
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Permiso> $permisos
     * @property-read int|null $permisos_count
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereIdModulo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereNombreModulo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereRuta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereIcono($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereOrden($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereTipoModulo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo query()
     * @method static \Illuminate\Database\Eloquent\Builder<Modulo>|Modulo activos() {@see App\Models\Modulo::scopeActivos()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Modulo extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Notificacion
     *
     * @property \Illuminate\Support\Carbon $fecha_notificacion
     * @property \Illuminate\Support\Carbon|null $fecha_lectura
     * @property boolean $i_leido
     * @property string|null $mensaje
     * @property mixed $tipo_notificacion
     * @property int $id_usuario
     * @property int $id_resolucion
     * @property int $id_notificacion
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereIdNotificacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereTipoNotificacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereMensaje($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereILeido($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereFechaLectura($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion whereFechaNotificacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion query()
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion noLeidas() {@see App\Models\Notificacion::scopeNoLeidas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion leidas() {@see App\Models\Notificacion::scopeLeidas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion porUsuario(mixed $idUsuario) {@see App\Models\Notificacion::scopePorUsuario()}
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion porTipo(mixed $tipo) {@see App\Models\Notificacion::scopePorTipo()}
     * @method static \Illuminate\Database\Eloquent\Builder<Notificacion>|Notificacion recientes(mixed $dias = 7) {@see App\Models\Notificacion::scopeRecientes()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Notificacion extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Permiso
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $tipo_permiso
     * @property boolean $i_active
     * @property string|null $descripcion
     * @property string $guard_name
     * @property string|null $slug
     * @property string $name
     * @property int|null $id_modulo
     * @property int $id
     * @property-read \App\Models\Modulo $modulo
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UsuarioPermisoMetadata> $metadata
     * @property-read int|null $metadata_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
     * @property-read int|null $roles_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
     * @property-read int|null $users_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
     * @property-read int|null $permissions_count
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereIdModulo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereGuardName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereTipoPermiso($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso query()
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso activos() {@see App\Models\Permiso::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso porModulo(mixed $idModulo) {@see App\Models\Permiso::scopePorModulo()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso crud() {@see App\Models\Permiso::scopeCrud()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso especial() {@see App\Models\Permiso::scopeEspecial()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso role(mixed $roles, mixed $guard = null, mixed $without = false) {@see App\Models\Permiso::scopeRole()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso withoutRole(mixed $roles, mixed $guard = null) {@see App\Models\Permiso::scopeWithoutRole()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso permission(mixed $permissions, mixed $without = false) {@see App\Models\Permiso::scopePermission()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permiso>|Permiso withoutPermission(mixed $permissions) {@see App\Models\Permiso::scopeWithoutPermission()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Permiso extends \Spatie\Permission\Models\Permission
    {
        //
    }

    /**
     * App\Models\PersonaResolucion
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property boolean $i_active
     * @property \Illuminate\Support\Carbon|null $fecha_notificacion
     * @property boolean $i_notificado
     * @property mixed $tipo_relacion
     * @property int $id_persona
     * @property int $id_resolucion
     * @property int $id_persona_resolucion
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\Persona $persona
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereIdPersonaResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereIdPersona($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereTipoRelacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereINotificado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereFechaNotificacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion query()
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion activos() {@see App\Models\PersonaResolucion::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion involucrados() {@see App\Models\PersonaResolucion::scopeInvolucrados()}
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion notificados() {@see App\Models\PersonaResolucion::scopeNotificados()}
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion firmantes() {@see App\Models\PersonaResolucion::scopeFirmantes()}
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucion>|PersonaResolucion pendientesNotificacion() {@see App\Models\PersonaResolucion::scopePendientesNotificacion()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PersonaResolucion extends \Illuminate\Database\Eloquent\Relations\Pivot
    {
        //
    }

    /**
     * App\Models\PersonaResolucionDatos
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property \Illuminate\Support\Carbon|null $fecha_asignacion
     * @property boolean $asignado_a_cliente
     * @property boolean $es_interna
     * @property boolean $obtenido_reniec
     * @property string|null $descripcion_relacion
     * @property mixed $tipo_relacion
     * @property string|null $apellido_materno
     * @property string $apellido_paterno
     * @property string $nombres
     * @property string $num_documento
     * @property string $tipo_documento
     * @property int|null $id_user
     * @property int $id_resolucion
     * @property int $id_persona_resolucion_datos
     * @property-read mixed $nombre_completo
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\User $usuario
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\EnvioCredencial> $enviosCredenciales
     * @property-read int|null $enviosCredenciales_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RegistroFirmaEntrega> $registrosFirmaEntrega
     * @property-read int|null $registrosFirmaEntrega_count
     * @property-read \App\Models\RegistroFirmaEntrega $ultimoRegistroFirma
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereIdPersonaResolucionDatos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereIdUser($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereTipoDocumento($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereNumDocumento($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereNombres($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereApellidoPaterno($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereApellidoMaterno($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereTipoRelacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereDescripcionRelacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereObtenidoReniec($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereEsInterna($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereAsignadoACliente($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereFechaAsignacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PersonaResolucionDatos>|PersonaResolucionDatos query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PersonaResolucionDatos extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Queja
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property \Illuminate\Support\Carbon|null $fecha_respuesta
     * @property string|null $respuesta
     * @property int|null $id_usuario_atiende
     * @property mixed $estado
     * @property string $descripcion
     * @property mixed $tipo_queja
     * @property int $id_resolucion
     * @property int $id_cliente
     * @property int $id_queja
     * @property-read \App\Models\Cliente $cliente
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\User $usuarioAtiende
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereIdQueja($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereIdCliente($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereTipoQueja($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereEstado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereIdUsuarioAtiende($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereRespuesta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereFechaRespuesta($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja query()
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja pendientes() {@see App\Models\Queja::scopePendientes()}
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja enRevision() {@see App\Models\Queja::scopeEnRevision()}
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja resueltas() {@see App\Models\Queja::scopeResueltas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Queja>|Queja porTipo(mixed $tipo) {@see App\Models\Queja::scopePorTipo()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Queja extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\RegistroFirmaEntrega
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $metadata_firma_peru
     * @property string|null $correo_destino
     * @property string|null $observaciones
     * @property string|null $codigo_verificacion
     * @property string|null $archivo_firmado_entrega
     * @property \Illuminate\Support\Carbon|null $fecha_entrega
     * @property \Illuminate\Support\Carbon|null $fecha_firma
     * @property \Illuminate\Support\Carbon $fecha_solicitud
     * @property boolean $firmado
     * @property int|null $id_usuario_solicita
     * @property int $id_usuario_firmante
     * @property int $id_persona_resolucion_datos
     * @property int $id_resolucion
     * @property int $id_registro_firma_entrega
     * @property-read mixed $estado_visual
     * @property-read mixed $color_estado
     * @property-read \App\Models\Resolucion $resolucion
     * @property-read \App\Models\PersonaResolucionDatos $personaExterna
     * @property-read \App\Models\User $usuarioFirmante
     * @property-read \App\Models\User $usuarioSolicita
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereIdRegistroFirmaEntrega($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereIdResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereIdPersonaResolucionDatos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereIdUsuarioFirmante($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereIdUsuarioSolicita($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereFirmado($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereFechaSolicitud($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereFechaFirma($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereFechaEntrega($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereArchivoFirmadoEntrega($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereCodigoVerificacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereObservaciones($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereCorreoDestino($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereMetadataFirmaPeru($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega query()
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega firmados() {@see App\Models\RegistroFirmaEntrega::scopeFirmados()}
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega pendientes() {@see App\Models\RegistroFirmaEntrega::scopePendientes()}
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega deResolucion(mixed $idResolucion) {@see App\Models\RegistroFirmaEntrega::scopeDeResolucion()}
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega dePersona(mixed $idPersona) {@see App\Models\RegistroFirmaEntrega::scopeDePersona()}
     * @method static \Illuminate\Database\Eloquent\Builder<RegistroFirmaEntrega>|RegistroFirmaEntrega entregados() {@see App\Models\RegistroFirmaEntrega::scopeEntregados()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class RegistroFirmaEntrega extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Rol
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string|null $descripcion
     * @property string $nombre_rol
     * @property int $id_rol
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereIdRol($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereNombreRol($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Rol>|Rol query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Rol extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\SesionCliente
     *
     * @method static \Illuminate\Database\Eloquent\Builder<SesionCliente>|SesionCliente newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SesionCliente>|SesionCliente newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SesionCliente>|SesionCliente query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class SesionCliente extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\TipoPersonal
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property boolean $i_active
     * @property string $nombre_tipo_personal
     * @property int $id_tipo_personal
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal whereIdTipoPersonal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal whereNombreTipoPersonal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal query()
     * @method static \Illuminate\Database\Eloquent\Builder<TipoPersonal>|TipoPersonal activos() {@see App\Models\TipoPersonal::scopeActivos()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class TipoPersonal extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\TipoResolucion
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property \Illuminate\Support\Carbon $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string $nombre_tipo_resolucion
     * @property int $id_tipo_resolucion
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Resolucion> $resoluciones
     * @property-read int|null $resoluciones_count
     * @property-read \App\Models\User $usuario
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion whereIdTipoResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion whereNombreTipoResolucion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion query()
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion activos() {@see App\Models\TipoResolucion::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<TipoResolucion>|TipoResolucion buscar(mixed $search) {@see App\Models\TipoResolucion::scopeBuscar()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class TipoResolucion extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Unidad
     *
     * @property \Illuminate\Support\Carbon $fecha_actualizacion
     * @property string $fecha_creacion
     * @property int|null $id_usuario
     * @property boolean $i_active
     * @property string $nombre_unidad
     * @property int $id_unidad
     * @property-read \App\Models\User $usuario
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Colaborador> $colaboradores
     * @property-read int|null $colaboradores_count
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad whereIdUnidad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad whereNombreUnidad($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad whereFechaCreacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad whereFechaActualizacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad query()
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad activas() {@see App\Models\Unidad::scopeActivas()}
     * @method static \Illuminate\Database\Eloquent\Builder<Unidad>|Unidad buscar(mixed $search) {@see App\Models\Unidad::scopeBuscar()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Unidad extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\UsuarioPermisoMetadata
     *
     * @property boolean $i_active
     * @property \Illuminate\Support\Carbon|null $fecha_revocacion
     * @property \Illuminate\Support\Carbon $fecha_asignacion
     * @property string|null $observacion
     * @property int|null $id_usuario_asigna
     * @property int $permission_id
     * @property int $id_usuario
     * @property int $id_metadata
     * @property-read \App\Models\User $usuario
     * @property-read \App\Models\Permiso $permiso
     * @property-read \App\Models\User $usuarioAsigna
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereIdMetadata($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereIdUsuario($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata wherePermissionId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereIdUsuarioAsigna($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereObservacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereFechaAsignacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereFechaRevocacion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata query()
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata activos() {@see App\Models\UsuarioPermisoMetadata::scopeActivos()}
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata revocados() {@see App\Models\UsuarioPermisoMetadata::scopeRevocados()}
     * @method static \Illuminate\Database\Eloquent\Builder<UsuarioPermisoMetadata>|UsuarioPermisoMetadata porUsuario(mixed $idUsuario) {@see App\Models\UsuarioPermisoMetadata::scopePorUsuario()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class UsuarioPermisoMetadata extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

}

namespace Spatie\Permission\Models {

    /**
     * Spatie\Permission\Models\Permission
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $tipo_permiso
     * @property bool $i_active
     * @property string|null $descripcion
     * @property string $guard_name
     * @property string|null $slug
     * @property string $name
     * @property int|null $id_modulo
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
     * @property-read int|null $roles_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
     * @property-read int|null $users_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
     * @property-read int|null $permissions_count
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereIdModulo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereGuardName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereDescripcion($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereIActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereTipoPermiso($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission query()
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission role(mixed $roles, mixed $guard = null, mixed $without = false) {@see Spatie\Permission\Models\Permission::scopeRole()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutRole(mixed $roles, mixed $guard = null) {@see Spatie\Permission\Models\Permission::scopeWithoutRole()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission permission(mixed $permissions, mixed $without = false) {@see Spatie\Permission\Models\Permission::scopePermission()}
     * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutPermission(mixed $permissions) {@see Spatie\Permission\Models\Permission::scopeWithoutPermission()}
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, $uniqueBy, $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Permission extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

}